//
//  AdViewView.h
//  Adview SDK
//
//  Created by Adview on 1/1/19.
//  Copyright © 2019 Adview. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "AdViewViewDelegate.h"

@interface AdViewView : UIView
@property (nonatomic, weak) id <AdViewViewDelegate> delegate;
@property (nonatomic, readonly,assign) AdvertType advertType;   //Banner、Interstitial、Spread

/**
 Banner request

 @param size banner size
 @param positionId banner positionId
 @param type see AdViewBannerType
 @param delegate see AdViewViewDelegate
 @return the Banner view
 */
+ (AdViewView *)requestBannerSize:(AdViewBannerSize)size
                       bannerType:(AdViewBannerType)type
                       positionId:(NSString *)positionId
                         delegate:(id<AdViewViewDelegate>)delegate;

/**
 Interstitial request
 @param positionId Interstitial positionId
 @param delegate see AdViewViewDelegate
 @return the interstitial view
 */
+ (AdViewView *)requestAdInterstitialWithPositionId:(NSString *)positionId
                                      delegate:(id<AdViewViewDelegate>)delegate;

/**
 Spread request
 
 @param positionId Spread positionId
 @param delegate see AdViewViewDelegate
 @return the Spread view
 */
+ (AdViewView *)requestSpreadActivityWithPositionId:(NSString *)positionId
                                           delegate:(id<AdViewViewDelegate>)delegate;

/**
 SDK version

 @return version stiring
 */
+ (NSString *)sdkVersion;

/**
 In the bid mode, you should call it when the delegate method [adViewObject:didReceiveBidPrice:] called back and ther price win.
 It will request ad content & report a result.
 */
- (void)bidSuccess;

/**
 Similar to the use of SEL: bidSuccess.
 It only reports a result
 */
- (void)bidFailure;

/**
 Show the Interstitial with a viewController

 @param rootViewController where Interstitial to show
 @return show success
 */
- (BOOL)showInterstitialWithRootViewController:(UIViewController *)rootViewController;
- (void)pauseRequestAd;
- (void)resumeRequestAd;
- (void)clearCaches;
/**
 COPPA Applicability
 
 The value of isUserCoppa supplied by the publisher. Is nil if the publisher hasn't specified child directed treatment. Is @YES if child directed treatment is enabled.
 */
+ (void)isSubjectCOPPA:(NSNumber *)isUserCoppa;

+ (NSNumber* )getChildDirectedTreatment;
@end
