//
//  TwoStepVideoViewController.m
//  AdViewSDKDemo
//
//  Created by adview on 2023/6/14.
//  Copyright © 2023 AdView. All rights reserved.
//

#import "TwoStepVideoViewController.h"

@interface TwoStepVideoViewController () <AdViewVideoDelegate>
@property (nonatomic, strong) AdViewVideo * video;
@property (nonatomic) BOOL isReady;
@end

@implementation TwoStepVideoViewController

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    self.isReady = NO;
}


- (void)requestButtonClick:(UIButton *)sender {
    if(self.isReady) {
        [self.video showVideoWithController:self];
    }else {
        self.video = [AdViewVideo playVideoWithAppId:ADVIEW_APPID
                                          positionId:ADVIEW_POSID_VIDEO
                                           videoType:AdViewVideoTypeInstl
                                            delegate:self];
        [self.video setInterfaceOrientations:[UIApplication sharedApplication].statusBarOrientation];
        [self.video getVideoAD];
    }
}

- (void)adViewVideoDidReceiveAd:(NSString *)vastString {
    NSLog(@"%@",vastString);
}

- (void)adViewVideoIsReadyToPlay:(AdViewVideo *)video {
    self.requestButton.text = [NSString stringWithFormat:@"%@ %@", NSLocalizedString(@"PlAY", nil),
                           [NSStringFromClass(self.class) stringByReplacingOccurrencesOfString:@"ViewController"
                                                                                    withString:@""]];
    self.isReady = YES;
}

- (void)adViewVideoFailReceiveDataWithError:(NSError *)error {
    NSLog(@"%s - %@",__FUNCTION__, error.domain);
}

- (void)adViewVideoPlayStarted {
    NSLog(@"%s", __FUNCTION__);
}

- (void)adViewVideoPlayEnded {
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewVideoSkipped {
    NSLog(@"%s", __FUNCTION__);
}
- (void)adViewVideoClosed {
    self.isReady = NO;
    self.requestButton.text = [NSString stringWithFormat:@"%@ %@", NSLocalizedString(@"REQ", nil),
                           [NSStringFromClass(self.class) stringByReplacingOccurrencesOfString:@"ViewController"
                                                                                    withString:@""]];
    self.video = nil;
    NSLog(@"%s", __FUNCTION__);
    
}


/*
#pragma mark - Navigation

// In a storyboard-based application, you will often want to do a little preparation before navigation
- (void)prepareForSegue:(UIStoryboardSegue *)segue sender:(id)sender {
    // Get the new view controller using [segue destinationViewController].
    // Pass the selected object to the new view controller.
}
*/

@end
