//
//  SubViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "SubViewController.h"

@interface SubViewController ()
@end

@implementation SubViewController

- (BOOL)logMode {
    return YES;
}

- (UIScrollView *)backgroundScrollView {
    if (!_backgroundScrollView) {
        _backgroundScrollView = [[UIScrollView alloc] init];
    }
    return _backgroundScrollView;
}

//- (UISlider *)backgroundScrollViewFrameSlider {
//    if (!_backgroundScrollViewFrameSlider) {
//        _backgroundScrollViewFrameSlider = [[UISlider alloc] init];
//        _backgroundScrollViewFrameSlider.value = 1.0f;
//        _backgroundScrollViewFrameSlider.continuous = NO;
//        [_backgroundScrollViewFrameSlider addTarget:self action:@selector(sliderValueChanged:) forControlEvents:UIControlEventValueChanged];
//    }
//    return _backgroundScrollViewFrameSlider;
//}
//- (UILabel *)percentLabel {
//    if (!_percentLabel) {
//        _percentLabel = [[UILabel alloc] init];
//        _percentLabel.textAlignment = NSTextAlignmentCenter;
//        _percentLabel.text = @"100 %";
//    }
//    return _percentLabel;
//}
- (UILabel *)requestButton {
    if (!_requestButton) {
        _requestButton = [UILabel new];
        _requestButton.textAlignment = NSTextAlignmentCenter;
        _requestButton.textColor = [UIColor whiteColor];
        _requestButton.text = [NSString stringWithFormat:@"%@ %@", NSLocalizedString(@"REQ", nil),
                               [NSStringFromClass(self.class) stringByReplacingOccurrencesOfString:@"ViewController"
                                                                                        withString:@""]];
        if (@available(iOS 13.0, *)) {
            UINavigationBarAppearance *navBar = self.navigationController.navigationBar.standardAppearance;
            _requestButton.backgroundColor =  navBar.backgroundColor;
            
        } else {
            // Fallback on earlier versions
            _requestButton.backgroundColor = self.navigationController.navigationBar.barTintColor;
        };
        _requestButton.userInteractionEnabled = YES;
        UITapGestureRecognizer * tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(requestButtonClick:)];
        [_requestButton addGestureRecognizer:tap];
        [self.view addSubview:_requestButton];
    }
    return _requestButton;
}

- (UILabel *)closebutton {
    if (!_closebutton) {
        _closebutton = [UILabel new];
        _closebutton.textAlignment = NSTextAlignmentCenter;
        _closebutton.textColor = [UIColor whiteColor];
        _closebutton.text = NSLocalizedString(@"CLOSE_BUTTON",nil);
        if (@available(iOS 13.0, *)) {
            UINavigationBarAppearance *navBar = self.navigationController.navigationBar.standardAppearance;
            _closebutton.backgroundColor =  navBar.backgroundColor;
            
        } else {
            // Fallback on earlier versions
            _closebutton.backgroundColor = self.navigationController.navigationBar.barTintColor;
        };
        _closebutton.userInteractionEnabled = YES;
        UITapGestureRecognizer * tap = [[UITapGestureRecognizer alloc] initWithTarget:self action:@selector(closeButtonClick:)];
        [_closebutton addGestureRecognizer:tap];
        [self.view addSubview:_closebutton];
    }
    return _closebutton;
}

- (void)sliderValueChanged:(id)slider {
    NSLog(@"%@",slider);
}

- (void)requestButtonClick:(UITapGestureRecognizer *)recognizer {
    NSLog(@"Error");
}

- (void)closeButtonClick:(UITapGestureRecognizer *)recognizer {
    NSLog(@"Error");
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    [self.navigationController setNavigationBarHidden:NO];
}

- (void)viewDidLoad {
    [super viewDidLoad];
    
    self.title = NSStringFromClass(self.class);
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationController.navigationBar.tintColor = [UIColor whiteColor];
    self.navigationController.navigationBar.titleTextAttributes = @{NSForegroundColorAttributeName:[UIColor whiteColor]};
    
    [self.view addSubview:self.backgroundScrollView];
    
//    [AdViewView isSubjectCOPPA:@YES];
}

- (void)addSizeCtrlView {
    self.backgroundScrollView.backgroundColor = [UIColor lightGrayColor];
    [self.view addSubview:self.backgroundScrollViewFrameSlider];
    [self.view addSubview:self.percentLabel];

    self.backgroundScrollViewFrameSlider.hidden = NO;
    self.percentLabel.hidden = NO;
}

- (void)resetCtrlView {
    self.backgroundScrollViewFrameSlider.value = 1.f;
    self.percentLabel.text = @"100 %";
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    
    CGFloat y = 0;
    self.requestButton.frame = CGRectMake((self.view.frame.size.width - 200) / 2,
                                          self.view.frame.size.height / 3 * 2,
                                          200,
                                          50);
    
    y = _requestButton.frame.origin.y - 100;
    
    _backgroundScrollViewFrameSlider.frame = CGRectMake(SPACE, y, self.view.frame.size.width - SPACE * 2, 50);
    
    y = _backgroundScrollViewFrameSlider.frame.origin.y + 40;
    
    _percentLabel.frame = CGRectMake(SPACE, y, self.view.frame.size.width, 20);
}


- (void)dealloc {
    NSLog(@"%s",__FUNCTION__);
}

@end
