//
//  MRECViewController.m
//  AdViewSDKDemo
//
//  Created by unakayou on 11/1/19.
//  Copyright © 2019 AdView. All rights reserved.
//

#import "MRECViewController.h"

@interface MRECViewController () <AdViewViewDelegate>
@property (nonatomic, strong) AdViewView * MREC;
@end

@implementation MRECViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    [self addSizeCtrlView];
}

- (void)requestButtonClick:(UIButton *)sender {
    [self.MREC removeFromSuperview];
    int videoMREC = arc4random() % 2;
    if (videoMREC) {
        self.MREC = [AdViewView requestBannerSize:AdViewBannerSize_300x250
                                       bannerType:AdViewBannerType_normal
                                       positionId:ADVIEW_POSID_MREC_NORMAL
                                         delegate:self];
    } else {
        self.MREC = [AdViewView requestBannerSize:AdViewBannerSize_300x250
                                       bannerType:AdViewBannerType_video
                                       positionId:ADVIEW_POSID_MREC_VIDEO
                                         delegate:self];
    }
    
    [self.backgroundScrollView addSubview:self.MREC];
    self.backgroundScrollView.bounds = self.MREC.frame;
}

- (void)closeButtonClick:(UITapGestureRecognizer *)recognizer {
    [self.MREC removeFromSuperview];
    self.MREC = nil;
}
- (void)adViewDidDisplayAd:(AdViewView *)adView {
    
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"Already Displayed");
}
- (void)adViewdidFailToDisplayAd:(AdViewView *)adView Error:(NSError*)error {
    NSLog(@"%s",__FUNCTION__);
    NSLog(@"%@", error);
    
}
- (void)adViewDidFinishShow:(AdViewView *)adview {
    NSLog(@"%s", __FUNCTION__);
}
- (void)sliderValueChanged:(UISlider *)slider {
    CGRect bannerFrame = self.MREC.frame;
    bannerFrame.size.height *= slider.value;
    if (!CGRectEqualToRect(CGRectZero, bannerFrame)) self.backgroundScrollView.bounds = bannerFrame;
    self.percentLabel.text = [NSString stringWithFormat:@"%.f %%", slider.value * 100];
}

- (NSString *)appId {
    return ADVIEW_APPID;
}

- (UIViewController *)viewControllerForShowModal {
    return self;
}

- (void)didReceivedAd:(AdViewView *)adView {
    NSLog(@"%s - %@",__FUNCTION__, adView);
    [self resetCtrlView];
    self.backgroundScrollView.bounds = self.MREC.frame;
}

- (void)adViewDidDismissScreen:(AdViewView *)adView
{
    NSLog(@"%s", __FUNCTION__);
}

- (void)adViewVideoClosed :(AdViewView *)adView{

    [self.MREC removeFromSuperview];
    self.MREC = nil;

}

- (void)didFailToReceiveAd:(AdViewView *)adView Error:(NSError *)error {
    NSLog(@"%s - %@",__FUNCTION__, error.domain);
}

- (void)viewDidLayoutSubviews {
    [super viewDidLayoutSubviews];
    
    CGRect contentFrame = self.backgroundScrollView.frame;
    if (self.MREC) {
        contentFrame.origin.x = (self.view.frame.size.width - self.MREC.frame.size.width) / 2;
    }
    contentFrame.origin.y = SPACE + 80;
    self.backgroundScrollView.frame = contentFrame;
    self.backgroundScrollView.contentSize = CGSizeMake(0, self.MREC.frame.size.height);
    
    CGRect requestButtonFrame = self.requestButton.frame;
    requestButtonFrame.origin.y += SPACE + requestButtonFrame.size.height;
    self.closebutton.frame = requestButtonFrame;
}


@end
